﻿using System;
using System.Linq;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
    public partial class ETLDB : DBUtils
    {
        #region Fields
        #endregion

        #region Constructors

        public ETLDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public Int32 CDW_GetCount(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, RegistryWizard registryWizard)
        {
            Int32 objReturn = 0;
            CDW_GETData_WizardResult objTemp = null;

            try
            {
                string oefOif = string.Empty;

                if (registryWizard.OEFOIFLocation.Value)
                    oefOif = "1";
                else
                    oefOif = "0";

                using (ETLDBDataContext dbContext = GetEtlDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objTemp = dbContext.CDW_GETData_Wizard(registryWizard.StdRegistryId, registryWizard.CombatLocIds, registryWizard.EthnicityIds, registryWizard.GenderIds, oefOif, registryWizard.RaceIds, registryWizard.ServiceIds, registryWizard.MaritalStatusIds, registryWizard.DOBMin, registryWizard.DOBMax, registryWizard.Username, registryWizard.Count, registryWizard.ICD9, registryWizard.ICD10, registryWizard.HealthFactorType).FirstOrDefault();
                    if (objTemp != null)
                        objReturn = objTemp.Record_Count.GetValueOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        #endregion
    }
}
